
  /*
   *  Object %name    : main.c%
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file includes the RND parsing functions  
   *
   *  \version parser.c#1:csrc:1
   *  \author mottig
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************* Include Files ****************/

#include "DX_VOS_BaseTypes.h"
#include "extapp_err.h"
#include "sep_utils.h"
#include "crysatptest_msg_defs.h"
#include "CRYS_SEP_ATP_Defines.h"
#include "DX_VOS_Mem.h"
#include "CRYS_SEP_ATP_RND_Acceptance.h"

// temp
//#include "gen_release.h"
//#include "sep_hw_defs.h"
//#include "cache_defs.h"


/************************ Defines ****************************/
/************************ Enums ******************************/
/************************ Typedefs ***************************/
/************************ Global Data ************************/
extern DxUint8_t   FailureFunctionNameOut[TST_FUNC_STRING_LEN];
/**************** Private function prototypes ****************/

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_RND_No_Reset

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* RND test without reset.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_RND_No_Reset(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;
	DxUint16_t	SEP_RNDSize;
	
	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;
	

	/* 1. extract parameters from the message */
	/******************************************/
	SEP_RNDSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_RND_SIZE_IN_OFFSET];
	
	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_RND_MSG_LENGTH_IN_WORDS;
		
	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_RND_No_Reset(SEP_RNDSize,
								   FailureFunctionNameOut);
		

	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}

/*****************************************************************************
* Function Name:                                                           
*  DX_SEP_PARSER_RND_Reset

*  
* Inputs:
*  msg - message with all requested parameters.
*
* Outputs: 
*  CRYSError_t - Function error return                                     
*
* Description:                                                                 
* This function does the parsing for the external application that executes
* RND test with reset.
* It calls the SEP function with parameters parsed from input message
* Algorithm: 
* 1. extract parameters from the message 
* 2. call QA SEP function
* 3. end SEP message and return
******************************************************************************/                                
DxUint32_t DX_SEP_PARSER_RND_Reset(DxUint32_t* msg)
{

	/********* Variables Definitions ************/
	DxUint32_t	SEP_Error = DX_SUCCESS;
	DxUint16_t	SEP_RNDSize;

	/* message length in words */
	DxUint32_t	SEP_MsgLengthInWords;


	/* 1. extract parameters from the message */
	/******************************************/
	SEP_RNDSize = (DxUint16_t)msg[DX_EXT_SEP_HOST_RND_SIZE_IN_OFFSET];

	/* message length in words = length of the not buffer parameters */
	/* + all buffers parameters maximal lengthes                     */
	SEP_MsgLengthInWords = DX_SEP_HOST_SEP_RND_MSG_LENGTH_IN_WORDS;

	/* 2. call QA SEP function */
	/***************************/
	SEP_Error = SEPQA_RND_Reset(SEP_RNDSize,
								FailureFunctionNameOut);


	if(SEP_Error != CRYS_OK)
	{
		/* output parameters are placed after msg RC */
		DX_VOS_FastMemCpy((DxUint8_t  *)&msg[DX_SEP_HOST_SEP_PROTOCOL_MSG_RC_OFFSET + 1], (DxUint8_t  *)&FailureFunctionNameOut[0], TST_FUNC_STRING_LEN);
		SEP_MsgLengthInWords = TST_FUNC_STRING_LEN/sizeof(DxUint32_t);
	}

	/* 3. end SEP message and return */
	/**********************/
	return DX_SEP_EndMessage(msg, SEP_Error, SEP_MsgLengthInWords*sizeof(DxUint32_t));
}




